<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Post_Post_Model extends Pf_Plugin_Model
{

    protected $table = 'pf_posts';
    protected $prefix_column = 'post';
    protected $primary_key = 'id';
    protected $timestamps = true;
    public $rules = array(
        'title' => 'required|min_len,2|max_len,255',
        'category' => 'numeric',
        'content' => 'required|min_len,2',
        'published_date' => 'date',
        'unpublished_date' => 'date',
        'thumbnail' => 'max_len,500'
    );

    public function status()
    {
        return array(1 => __('Published', 'post'), 0 => __('Unpublished', 'post'));
    }

    public function add_choice_category()
    {
        $catgory = new stdClass();
        $catgory->id = '';
        $catgory->category_name = __('Choose category', 'post');
        $catgory->category_parent = 0;
        $catgory->level = 0;
        return $catgory;
    }

}
